$MOD51
;*********
; PROGRAM PENULISAN KARAKTER DENGAN MENGGUNAKAN TEKNIK PENULISAN PADA KEYPAD
; HANDPHONE OLEH MODUL DST-51, KEYPAD 4X3 & M1632 LCD

        DSEG
CharCounter:     Ds      1

	Org	50H
        CSEG

Delay_500mS			EQU	0099H             
;Menunda waktu selama 500 mS (timer 0 digunakan)


KirimPesan_LCD			EQU	160DH             
;Mengirim data di alamat yang ditunjuk oleh DPTR ke LCD hingga data 0F
;- DPTR diisi dengan alamat awal data yang dikirim
;- Akhir data adalah 0FH

Init_LCD			EQU	1619H             
;Inisialisasi LCD

Kirim_Perintah			EQU	1658H             
;Mengirim data ke register perintah LCD
;- Data diisi di akumulator

Kirim_Karakter			EQU	1677H             
;Mengirim data ke register data LCD
;- Data diisi di akumulator

Baris2				EQU	1681H             
;Memindah posisi cursor ke baris 2

ROM			EQU	2000H

	Org	ROM			;Reset Vector
	Ajmp	Start			;
	Org	ROM+3H			;External Interrupt 0 Vector
	Reti				;
	Org	ROM+0BH			;Timer 0 Interrupt Vector
	Reti				;
	Org	ROM+13H			;External Interrupt 1 Vector
	Reti				;
	Org	ROM+1BH			;Timer 1 Interrupt Vector
	Reti				;
	Org	ROM+23H			;Serial Interrupt Vector
	Reti				;
Start:
	Lcall	Init_LCD			;Inisial LCD
	Mov	CharCounter,#00			;
Loop:
	Mov	DPTR,#TabelKeypad		;Akses Keypad
	Lcall	Ambil_keypad			;
	Mov	A,Nilai				;Hasil dari penekanan keypad
						;tersimpan di variabel nilai
	Lcall	Kirim_Karakter			;Kirim hasil ke LCD
	Inc	CharCounter			;Char Counter + 1
	Mov	R7,CharCounter			;
	Cjne	R7,#16,Cek32			;Char Counter = 16, pindah
	Lcall	Baris2				;ke baris 2 LCD
	Ajmp	Loop				;

Cek32:
	Cjne	R7,#32,Loop			;Char Counter = 32, kembali
	Ajmp	Start				;ke baris 1

        $include (keypad2.asm)

TabelKodeTombol:
	DB	' 0',0
	Org	TabelKodeTombol+10
	DB	'.,?!-&1',0
	Org	TabelKodeTombol+20
	DB	'ABC2',0
	Org	TabelKodeTombol+30
	DB	'DEF3',0
	Org	TabelKodeTombol+40
	DB	'GHI4',0
	Org	TabelKodeTombol+50
	DB	'JKL5',0
	Org	TabelKodeTombol+60
	DB	'MNO6',0
	Org	TabelKodeTombol+70
	DB	'PQRS7',0
	Org	TabelKodeTombol+80
	DB	'TUV8',0
	Org	TabelKodeTombol+90
	DB	'WXYZ9',0
	Org	TabelKodeTombol+110
	DB	'#',0
	Org	TabelKodeTombol+120
	DB	'*',0

        $include (tabkey.asm)
        END
