        DSEG
TimeOutKeypad:   Ds      1
TotalTekan:      Ds      1               ;Jumlah penekanan keypad
Nilai:   Ds      1
KeypadBuffer:    Ds      1
        CSEG
Keypad	EQU	90H

	Org	$
Ambil_Keypad:
	Mov	Keypad,#0FFH		;
	Acall	RSTTimeKeypad		;Reset Timer Keypad
	Mov	A,TMOD			;Timer 0 mode 16 bit counter
	Anl	A,#0F0H			;
	Orl	A,#01H			;
	Mov	TMOD,A			;
	Clr	TR0			
ResetTotalTekan:
	Mov	TotalTekan,#0		;Total penekanan = 0

Tunggu_Ditekan:
	Mov	A,Keypad		;
	Cjne	A,#0FFH,KeypadDitekan	;
	Jnb	TF0,Tunggu_Ditekan
	Clr	TF0
	Inc	TimeOutKeypad
	Mov	R7,TimeOutKeypad
	Cjne	R7,#010,Tunggu_Ditekan
	Clr	TR0
	Ret

KeypadDitekan:
	Jb	P,Tunggu_Ditekan	;Periksa apakah baris dan kolom
					;telah terhubung
	Mov	R7,TotalTekan		;
	Cjne	R7,#0,TidakSkip
	Ajmp	Skip

TidakSkip:
	Mov	B,KeypadBuffer
	Clr	C
	Subb	A,B
	Jnz	GantiTombol
	Mov	A,Keypad	
skip:
	Mov	Keypadbuffer,Keypad
	Acall	KonversiTabel
	Jz	ResetTotalTekan		;Akhir data tombol?
	Inc	TotalTekan
	Mov	Nilai,A
	Lcall	Kirim_Karakter
	Mov	A,#04H
	Lcall	Kirim_Perintah
	Mov	A,#' '
	Lcall	Kirim_Karakter
	Mov	A,#06H
	Lcall	Kirim_Perintah
	Lcall	DelayBouncing3

	Acall	RSTTimeKeypad
TungguLepas:
	Mov	A,Keypad
	Setb	TR0
	Cjne	A,#0FFH,PeriksaTimer
	Setb	TR0
	Ajmp	Tunggu_Ditekan

PeriksaTimer:
	Jnb	TF0,TungguLepas
	Clr	TF0
	Inc	TimeOutKeypad
	Mov	R7,TimeOutKeypad
	Cjne	R7,#010,TungguLepas
	Mov	DPTR,#TabelKeypad

CariAkhirDataTombol:
	Mov	A,Keypad		;Cari akhir data tombol
	Acall	KonversiTabel		;
	Inc	TotalTekan		;
	Jnz	CariAkhirDataTombol		;
	Dec	TotalTekan		;
	Dec	TotalTekan		;
	Mov	A,KeypadBuffer		;Ambil data terakhir tombol
	Acall	KonversiTabel		;
	Mov	Nilai,A			;Simpan di Nilai
	Lcall	Kirim_Karakter
	Mov	A,#04H
	Lcall	Kirim_Perintah
	Mov	A,#' '
	Lcall	Kirim_Karakter
	Mov	A,#06H
	Lcall	Kirim_Perintah
BelumLepas:
	Mov	A,Keypad
	Cjne	A,#0FFH,BelumLepas

GantiTombol:
	Clr	TR0			;Stop Timer
	Ret

KonversiTabel:
	Movc	A,@A+DPTR
	Mov	B,#10
	Mul	AB
	Push	DPH
	Push	DPL
	Mov	DPTR,#TabelKodeTombol
	Mov	B,TotalTekan
	Add	A,B
	Movc	A,@A+DPTR
	Pop	DPL
	Pop	DPH
	Ret

Reset:
	Mov	TotalTekan,#00
	Ajmp	Tunggu_Ditekan

DelayBouncing3:
	Push	B
	Mov	B,#01
Loop2DelayBounce:
	Acall	DelayBouncing2
	Djnz	B,Loop2DelayBounce
	Pop	B
	Ret

DelayBouncing2:
	Push	B
	Mov	B,#0FFH
Loop1Delaybounce:
	Acall	DelayBouncing1	
	Djnz	B,Loop1Delaybounce
	Pop	B
	Ret

DelayBouncing1:
	Push	B
	Mov	B,#0FFH
	Djnz	B,$
	Pop	B
	Ret

RSTTimeKeypad:
	Mov	TH0,#00H
	Mov	TL0,#00H
	Mov	TimeOutKeypad,#00	
	Ret

