$MOD51
	DSEG
	Org	60h
BufferPassword:	Ds	8


	CSEG

ErrorLED	Bit	INT0
Solenoid	Bit	T0
Sensor		Bit	INT1

ROM			EQU	0000H

	Org	ROM			;Reset Vector
	Ajmp	Start			;
	Org	ROM+3H			;External Interrupt 0 Vector
	Reti				;
	Org	ROM+0BH			;Timer 0 Interrupt Vector
	Reti
	Org	ROM+13H			;External Interrupt 1 Vector
	Reti				;
	Org	ROM+1BH			;Timer 1 Interrupt Vector
	Reti				;
	Org	ROM+23H			;Serial Interrupt Vector
	Reti				;

PanjangPassword	EQU	4


Start:

Loop2:
	Acall	InitTimer		;Inisial timer untuk trap data
	Mov	R7,#PanjangPassword
	Mov	R0,#BufferPassword
Loop:
	Acall	AmbilRemote
	Cjne	A,#7FH,$+3		;Kode di bawah 80H, abaikan
	Lcall	Delay_100mS
	Lcall	Delay_100mS
	Lcall	Delay_100mS
	Jc	Loop			;
	Mov	@R0,A
	Inc	R0
	Mov	A,R7
	Djnz	R7,Loop	

	Acall	Verifikasi
	Jc	ErrorPassword	
	Clr	Solenoid
	Lcall	Delay_1detik
	Lcall	Delay_1detik
	Lcall	Delay_1detik
	Jnb	Sensor,$		;Tunggu pintu tertutup
	Setb	Solenoid
	Ajmp	Loop2

ErrorPassword:
	Clr	ErrorLED
	Lcall	Delay_1detik
	Setb	ErrorLED
	Ajmp	Loop2		

Verifikasi:
	Mov	R0,#BufferPassword
	Mov	DPTR,#TabelPassword
	Mov	R7,#PanjangPassword

LoopVerifikasi:
	Mov	A,#00
	Movc	A,@A+DPTR
	Inc	DPTR
	Mov	B,@R0
	Inc	R0
	Clr	C
	Subb	A,B
	Jnz	Error
	Djnz	R7,LoopVerifikasi
	Clr	C
	Ret

Error:
	Setb	C
	Ret

AmbilRemote:
	Push	07H
	Acall	CekStartBit		;Tunggu Start Bit
	Mov	R7,#8			;Panjang data bit = 8

AmbilData:
        Push    Acc                       ;Ambil 1 bit
        Acall   AmbilBit                     ;
        Pop     Acc                       ;
	Rrc	A			;Geser ke akumulator
	Djnz	R7,AmbilData		;Lakukan 8x
	Clr	TR0
	Pop	07H
	Ret

CekStartBit:
	Jb	RXD,$
	Setb	TR0
	Jnb	RXD,$
	Mov	A,TH0
	Cjne	A,#08H,$+3
	Jnc	CekStartBitSelesai
	Clr	TR0
	Mov	TH0,#00
	Mov	TL0,#00
	Ajmp	CekStartBit

CekStartBitSelesai:
	Clr	TR0
	Mov	TH0,#00
	Mov	TL0,#00
	Ret


AmbilBit:
	Jb	RXD,$
	Setb	TR0
	Jnb	RXD,$
	Clr	TR0
	Mov	A,TH0
	Cjne	A,#03,$+3
	Jnc	Bit1
	Clr	C
	Mov	TH0,#0
	Mov	TL0,#0
	Ret

Bit1:
	Setb	C
	Mov	TH0,#0
	Mov	TL0,#0
	Ret

InitTimer:
	Mov	TH0,#00			;
	Mov	TL0,#00			;
        Push    ACC                       ;
	Mov	A,TMOD
	Anl	A,#0F0H
	Orl	A,#01H
	Mov	TMOD,A
        Pop     ACC
	Ret

        $include (delay_1d.asm)

TabelPassword:
	DB	80h,81h,82h,83h

	END
