;***********************
; RUTIN TIMER
; - Tampilan 		: M1632 LCD
; - Input data		: Keypad 4x3
; - Satuan Timer 	: 10 mili detik
; - Bentuk tampilan	: Jam : menit : detik
;***********************

	DSEG
	Org	$
NilaiTimer:	Ds	6		;mili detik, detik, menit
StackTimer:	Ds	1		;Stack Timer Temporary
RTemp:		Ds	6		;Register Temporary

	CSEG
	Org	$
;***************
; RUTIN UNTUK MENGAKTIFKAN TIMER
;****************
StartTimer0:
	Mov	StackTimer,SP		;Simpan nilai Stack Pointer 
	Mov	A,TMOD			;Atur mode timer 0 tanpa mengubah
	Anl	A,#0F0H			;mode timer 1
	Orl	A,#01H			;
	Mov	TMOD,A			;
	Acall	ResetTimer0		;
	Setb	EA			;Aktifkan Interupsi
	Setb	ET0			;
	Setb	TR0			;Aktifkan Timer 0
	Ret

;****************
; RUTIN ISI NILAI AWAL TIMER DENGAN KEYPAD DAN TAMPILKAN DI M1632 LCD
;****************

ResetNilaiTimer:
	Mov	NilaiTimer+3,#00
	Mov	NilaiTimer+2,#00
	Mov	NilaiTimer+1,#00
	Mov	NilaiTimer,#00
	
	Ret					;

;**********************
; HARGA AWAL TIMER 0
; - Rutin memberi harga awal nilai timer 0 yang berfungsi sebagai pre scaler
;   dari timer
; - Jumlah siklus x 12/Frekwensi crystal = 10 mS
;   Jumlah siklus = 10 mS x Frekwensi crystal / 12
;   Jumlah siklus = 9216 => 2400H
; - Nilai Timer = -jumlah siklus = -2400H = DC00H

Resettimer0:
	Mov	TH0,#0DCH		;Nilai Timer diisi
	Mov	TL0,#00H
	Ret

;**********************
; RUTIN INTERUPSI TIMER 0
; - Terjadi setiap 10 ms
; - Nilai Timer berkurang setiap 10 ms
;**********************

Timer0_Interrupt:
	Acall	ResetTimer0
	Acall	TambahWaktu
	Setb	ET0	
	Reti

;*******************
; RUTIN PENAMBAHAN WAKTU DENGAN FORMASI 24 HOURS
;*******************

TambahWaktu:
	Mov	R0,#NilaiTimer		;Mili detik + 1
	Inc	@R0			;
	Mov	A,@R0			;
	Cjne	A,#100,TidakReset	;
	Mov	@R0,#00			;Mili detik = 100 -> Mili detik = 00
	Acall	DisplayTimer		;Tampilkan nilai timer
	Inc	R0			;Detik + 1
	Inc	@R0			;
	Mov	A,@R0			;

	Cjne	A,#60,TidakReset	;Detik = 60 -> Detik = 00
	Mov	@R0,#00			;
	Inc	R0			;
	Inc	@R0			;Detik + 1
	Mov	A,@R0			;

	Cjne	A,#60,TidakReset	;Menit = 60 -> Menit = 00
	Mov	@R0,#00			;
	Inc	R0			;
	Dec	@R0			;Menit + 1
	Mov	A,@R0			;
	
	Cjne	A,#24,TidakReset	;Jam = 24 -> 00
	Mov	@R0,#00
	
TidakReset:
	Ret

;*************************************
; TAMPILKAN NILAI TIMER KE M1632 LCD
; - Nilai timer tersimpan dalam tabel desimal
; - Formasi tabel desimal adalah:
;	mili detik, detik, menit, jam
;*************************************
DisplayTimer:
        Push    ACC
	Lcall	Posisi_Awal
	Push	0H
	Push	7H
	Mov	R0,#NilaiTimer+3
	Mov	R7,#3
LoopdisplayTimer:
	Mov	A,@R0
	Acall	Konversi1bdesimal
	Mov	A,TabelDesimal+1
	Add	A,#30H
	Lcall	Kirim_Karakter
	Mov	A,TabelDesimal
	Add	A,#30H
	Lcall	Kirim_Karakter
	Dec	R0
	Djnz	R7,TampilkanTerus
	Pop	07H
	Pop	0H
        Pop     ACC
	Ret

TampilkanTerus:
	Mov	A,#':'
	Lcall	Kirim_Karakter
	Ajmp	LoopDisplayTimer
